/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.generatorfluid;

import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.generatorfluid.TileGeneratorFluid;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.recipe.ingredient.EnergyIngredient;
import com.lothrazar.cyclic.recipe.ingredient.FluidTagIngredient;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeGeneratorFluid<TileEntityBase>
extends CyclicRecipe {
    private NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    public final FluidTagIngredient fluidIng;
    private final EnergyIngredient energy;
    public static final SerializeGenerateFluid SERIALGENERATORF = new SerializeGenerateFluid();

    public RecipeGeneratorFluid(ResourceLocation id, FluidTagIngredient in, EnergyIngredient energy) {
        super(id);
        this.fluidIng = in;
        this.energy = energy;
    }

    @Override
    public FluidStack getRecipeFluid() {
        return this.fluidIng.getFluidStack();
    }

    public boolean matches(TileBlockEntityCyclic inv, Level worldIn) {
        try {
            TileGeneratorFluid tile = (TileGeneratorFluid)inv;
            return CyclicRecipe.matchFluid(tile.getFluid(), this.fluidIng);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(ItemStack current, Ingredient ing) {
        if (ing == Ingredient.f_43901_) {
            return current.m_41619_();
        }
        if (current.m_41619_()) {
            return ing == Ingredient.f_43901_;
        }
        return ing.test(current);
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.m_43908_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @Override
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public RecipeType<?> m_6671_() {
        return CyclicRecipeType.GENERATOR_FLUID;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALGENERATORF;
    }

    public int getTicks() {
        return this.energy.getTicks();
    }

    public int getRfpertick() {
        return this.energy.getRfPertick();
    }

    public int getRfTotal() {
        return this.getRfpertick() * this.getTicks();
    }

    public static class SerializeGenerateFluid
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<RecipeGeneratorFluid<? extends TileBlockEntityCyclic>> {
        SerializeGenerateFluid() {
            this.setRegistryName(new ResourceLocation("cyclic", "generator_fluid"));
        }

        public RecipeGeneratorFluid<? extends TileBlockEntityCyclic> fromJson(ResourceLocation recipeId, JsonObject json) {
            RecipeGeneratorFluid r = null;
            try {
                FluidTagIngredient fs = CyclicRecipe.parseFluid(json, "fuel");
                r = new RecipeGeneratorFluid(recipeId, fs, new EnergyIngredient(json));
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe " + recipeId, e);
            }
            return r;
        }

        public RecipeGeneratorFluid fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new RecipeGeneratorFluid(recipeId, FluidTagIngredient.readFromPacket(buffer), new EnergyIngredient(buffer.readInt(), buffer.readInt()));
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeGeneratorFluid recipe) {
            recipe.fluidIng.writeToPacket(buffer);
            buffer.writeInt(recipe.energy.getRfPertick());
            buffer.writeInt(recipe.energy.getTicks());
        }
    }
}

